////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#define TitleCaption      "SQLBackup"
#define FileVersion       "1.0.0.6"
#define RegistryKey       "Software\\NetWorkDLS\\SQLBackup"
#define Seperator         "______________________________________________________________________________"
#define VirtualDeviceName (unsigned short *)"SQLBackup"

//---------------------(HWND & INSTANCE Definitions)
HINSTANCE MainInstance            = NULL;	   // WinMain (Application) Instance
HWND MainDialog_hWnd              = NULL;	   // MainDialog Instance

HWND StatusListBox_hWnd           = NULL;

HWND ScheduleDialog_hWnd          = NULL;
HWND ViewScheduleDialog_hWnd      = NULL;
HWND SelectDBDialog_hWnd          = NULL;
HWND SQLPWDDialog_hWnd            = NULL;
HWND RestoreWithMoveDialog_hWnd   = NULL;

HWND ManBackupDialog_hWnd         = NULL;
HWND ManRestoreDialog_hWnd        = NULL;

HWND AddScheduleDialog_hWnd       = NULL;
HWND AddSQLOptionsDialog_hWnd     = NULL;
HWND AddBackupOptionsDialog_hWnd  = NULL;

HWND EditScheduleDialog_hWnd      = NULL;
HWND EditSQLOptionsDialog_hWnd    = NULL;
HWND EditBackupOptionsDialog_hWnd = NULL;

//---------------------(Function Prototypes)
void LBWrite(HWND, char *);
BOOL GetValues(void);
BOOL RestoreJob(char *);
BOOL BackupJob(char *);
int xMainEntry(void);
BOOL InitilizeAll(void);
BOOL UninitilizeAll(void);
void KillApplication(void);
void AddToJobHistory(char *);
void LoadJobHistory(HWND);

DWORD WINAPI SQLProcessThread(LPVOID);
DWORD WINAPI DialogThread(LPVOID);

//---------------------(Global Variables)

BOOL EndApplication   = FALSE;
BOOL AllOnHold        = FALSE;
BOOL RunningManual    = FALSE;
BOOL CurrentlyRunning = FALSE;
BOOL DoingTransfer    = FALSE;
BOOL CancelFlag       = FALSE;
BOOL StartupComplete  = FALSE;
BOOL RunningAsService = FALSE;
BOOL Initilized       = FALSE;

char JobHistory[500][500];
int InHistory = 0;

char TempBackupName[256];
char TempBackupDescription[256];

char SavedDataFile[256];

HANDLE SQLProcessThread_Handle = NULL;
DWORD SQLProcessThread_ID      = 0;

HANDLE DialogThread_Handle = NULL;
DWORD DialogThread_ID      = 0;

BOOL BackupTrusted  = FALSE;
BOOL RestoreTrusted = FALSE;

char MasterDriver[256];
char MasterServer[256];
char MasterDatabase[256];
char MasterUID[256];
char MasterPWS[256];

char BackupServer[256];
char RestoreServer[256];

char BackupDriver[256];
char RestoreDriver[256];

char BackupDataBase[256];
char RestoreDataBase[256];

char BackupFile[256];
char RestoreFile[256];

char BackupUserID[256];
char BackupUserPW[256];
char RestoreUserID[256];
char RestoreUserPW[256];

//---------------------(Global Structures)
struct _SQLProcess{
    int ScheduleItem;
    char DataBase[256];
    char Driver[256];
    BOOL IsTrusted;
    char Server[256];
    char UserID[256];
    char UserPW[256];
    BOOL Backup;
    char RestoreStatement[1024];
    char RestoreDBName[1024];
}; _SQLProcess SQLProcess;

//---------------------(Dialog Prototypes)
BOOL CALLBACK MainDialog(HWND, UINT, WPARAM, LPARAM);
BOOL CALLBACK SplashDialog(HWND, UINT, WPARAM, LPARAM);
BOOL CALLBACK ViewLogDialog(HWND, UINT, WPARAM, LPARAM);

BOOL CALLBACK ScheduleDialog(HWND, UINT, WPARAM, LPARAM);
BOOL CALLBACK ViewScheduleDialog(HWND, UINT, WPARAM, LPARAM);
BOOL CALLBACK SelectDBDialog(HWND, UINT, WPARAM, LPARAM);
BOOL CALLBACK SQLPWDDialog(HWND, UINT, WPARAM, LPARAM);
BOOL CALLBACK RestoreWithMoveDialog(HWND, UINT, WPARAM, LPARAM);

BOOL CALLBACK ManBackupDialog(HWND, UINT, WPARAM, LPARAM);
BOOL CALLBACK ManRestoreDialog(HWND, UINT, WPARAM, LPARAM);

BOOL CALLBACK AddScheduleDialog(HWND, UINT, WPARAM, LPARAM);
BOOL CALLBACK AddSQLOptionsDialog(HWND, UINT, WPARAM, LPARAM);
BOOL CALLBACK AddBackupOptionsDialog(HWND, UINT, WPARAM, LPARAM);

BOOL CALLBACK EditScheduleDialog(HWND, UINT, WPARAM, LPARAM);
BOOL CALLBACK EditSQLOptionsDialog(HWND, UINT, WPARAM, LPARAM);
BOOL CALLBACK EditBackupOptionsDialog(HWND, UINT, WPARAM, LPARAM);

////////////////////////////////////////////////////////////////////////////////////////////

